/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.devtools.WidgetInspector;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

@Singleton
public class WidgetInspectorOverlay
extends Overlay {
    private final Client client;
    private final WidgetInspector inspector;

    @Inject
    public WidgetInspectorOverlay(Client client2, WidgetInspector inspector) {
        this.client = client2;
        this.inspector = inspector;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(1.0f);
        this.drawAfterInterface(165);
    }

    @Override
    public Dimension render(Graphics2D g2) {
        Widget w2 = this.inspector.getSelectedWidget();
        if (w2 != null) {
            this.renderWidget(g2, w2, WidgetInspector.SELECTED_WIDGET_COLOR);
        }
        if (this.inspector.isPickerSelected()) {
            int i2;
            boolean menuOpen = this.client.isMenuOpen();
            MenuEntry[] entries = this.client.getMenuEntries();
            int n2 = i2 = menuOpen ? 0 : entries.length - 1;
            while (i2 < entries.length) {
                MenuEntry e2 = entries[i2];
                Widget w3 = this.inspector.getWidgetForMenuOption(e2.getType(), e2.getParam0(), e2.getParam1());
                if (w3 != null) {
                    Color color = this.inspector.colorForWidget(i2, entries.length);
                    this.renderWidget(g2, w3, color);
                }
                ++i2;
            }
        }
        return null;
    }

    private void renderWidget(Graphics2D g2, Widget w2, Color color) {
        g2.setColor(color);
        g2.draw(w2.getBounds());
    }
}

